import funkin.game.PlayState;
import flixel.text.FlxTextBorderStyle;

var sick = new FlxSprite().loadGraphic("images/game/score/sick.png");
var good = new FlxSprite().loadGraphic("images/game/score/good.png");
var bad = new FlxSprite().loadGraphic("images/game/score/bad.png");
var shit = new FlxSprite().loadGraphic("images/game/score/shit.png");
var ratingTxtTimeout = 0;
var combo:FlxText = new FlxText(0, 0, 0, "1");

function postCreate() {
	remove(PlayState.instance.comboGroup);
	for (i in [sick, good, bad, shit]) {
		i.cameras = [camHUD];
		i.scale.set(0.5, 0.5);
		i.updateHitbox();
		i.antialiasing = true;
		i.alpha = 0.001;
		i.screenCenter();
		i.y += 250;
		insert(members.indexOf(strumLines), i);
	}

	combo.cameras = [camHUD];
	combo.setFormat(Paths.font('vcr.ttf'), 50, 0xFFFFFFFF, null, FlxTextBorderStyle.OUTLINE, 0xFF000000);
	combo.borderSize = 2;
	combo.screenCenter(FlxAxes.X);
	combo.y = sick.y + 20;
	combo.alpha = 0.001;
	insert(members.indexOf(strumLines), combo);
	switch (curStage) {
		case "place" | "stickstage" | "gamerbg" | "FunkMix" | "kingcastle" | "morshushop" | "hotelcave" | "ohgod":
			__script__.active = false;
	}
}

function onPlayerHit(event:NoteHitEvent) {
	if (!event.note.isSustainNote) {
		ratingTxtTimeout = 26;
		FlxTween.cancelTweensOf(combo);
		combo.alpha = 0.001;
		for (i in [sick, good, bad, shit]) {
			FlxTween.cancelTweensOf(i);
			FlxTween.cancelTweensOf(i.scale);
			i.scale.set(0.43, 0.4);
			FlxTween.tween(i.scale, {x: 0.35, y: 0.35}, 0.6, {ease: FlxEase.elasticOut});
			// i.angle = FlxG.random.int(-7, 7);
		}
		switch (event.rating) {
			case 'sick':
				sick.alpha = 1;
				good.alpha = 0.001;
				bad.alpha = 0.001;
				shit.alpha = 0.001;
			case 'good':
				sick.alpha = 0.001;
				good.alpha = 1;
				bad.alpha = 0.001;
				shit.alpha = 0.001;
			case 'bad':
				sick.alpha = 0.001;
				good.alpha = 0.001;
				bad.alpha = 1;
				shit.alpha = 0.001;
			case 'shit':
				sick.alpha = 0.001;
				good.alpha = 0.001;
				bad.alpha = 0.001;
				shit.alpha = 1;
		}
		combo.text = (PlayState.instance.combo);
	}
}

function stepHit(step) {
	if (ratingTxtTimeout > 0)
		ratingTxtTimeout--;

	if (ratingTxtTimeout == 8) {
		for (i in [sick, good, bad, shit]) {
			FlxTween.tween(i, {alpha: 0.001}, 0.1);
			if (combo.alpha == 0.001 && PlayState.instance.combo > 0)
				hiCombo();
		}
	}
	if (ratingTxtTimeout == 0) {
		FlxTween.tween(combo, {alpha: 0.001}, 0.1);
	}
}

function hiCombo() {
	combo.screenCenter(FlxAxes.X);
	FlxTween.tween(combo, {alpha: 1}, 0.1);
}

function update(elapsed) {
	for (i in [sick, good, bad, shit]) {
		// i.scale.set(FlxMath.lerp(i.scale.x, 0.4, 0.1), FlxMath.lerp(i.scale.y, 0.4, 0.15));
		if (newRatingsRVisible)
			i.visible = true;
		else
			i.visible = false;
	}
	if (newRatingsRVisible)
		combo.visible = true;
	else
		combo.visible = false;
}
